﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class LineUI : MonoBehaviour
{
    public Image m_imageLine;//线
    public Image m_imageLineStart;
    public Image m_imageLineFinal;

    private Stack<GameObject> m_objStack = new Stack<GameObject>();
    private List<GameObject> m_objList = new List<GameObject>();
    private List<GameObject> m_lineLst = new List<GameObject>();
    public void DrawLine(Vector3 startP, Vector3 finalP)
    {
        Vector3 varStart = startP;
        varStart.x = (varStart.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        varStart.y = (varStart.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        varStart.z = 0;
        Vector3 varFinal = finalP;
        varFinal.x = (varFinal.x - Screen.width / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        varFinal.y = (varFinal.y - Screen.height / 2f) / (Screen.width / GlobalConfig.NormalWidth);
        varFinal.z = 0;
        Vector3 rightPosition = (varStart + varFinal) / 2;
        Vector3 rightRotation = varFinal - varStart;
        float HalfLength = Vector3.Distance(varStart, varFinal);
        //float LThickness = 0.1f;//线的粗细

        //创建圆柱体
        //GameObject MyLine = PoolManager.Instance.GetObjectFromPool(CacheManager.Instance.lineObj);
        m_imageLine.transform.localPosition = rightPosition;
        m_imageLine.transform.localRotation = Quaternion.FromToRotation(Vector3.up, rightRotation);
        Vector2 varSize = m_imageLine.rectTransform.sizeDelta;
        varSize.x = 250.0f;//HalfLength/m_imageLine.preferredHeight*m_imageLine.preferredWidth;
        varSize.y = HalfLength;
        m_imageLine.rectTransform.sizeDelta = varSize;
        m_imageLineStart.transform.localPosition = varStart;
        m_imageLineFinal.transform.localPosition = varFinal;


        //Vector3 varDir = (varFinal - varStart).normalized;
        //int varIndex = 0;
        //for(int i = 0;i<3;i++)
        //{
        //    varIndex++;
        //    GameObject varGo = GetPoolObject();
        //    varGo.transform.localPosition = varStart + varDir * varIndex * (HalfLength / 4.0f);
        //    m_lineLst.Add(varGo);
        //}
    }
    GameObject GetPoolObject()
    {
        GameObject varGo = null;
        if (m_objStack.Count > 0)
        {
            varGo = m_objStack.Pop();
        }
        else
        {
            varGo = GameObject.Instantiate(m_imageLineStart.gameObject);
            m_objList.Add(varGo);
        }
        varGo.SetActive(true);
        varGo.transform.SetParent(m_imageLineStart.transform.parent);
        varGo.transform.localRotation = Quaternion.identity;
        varGo.transform.localScale = Vector3.one;
        return varGo;
    }
    void ReturnObjectToPool(GameObject go)
    {
        if (go)
        {
            m_objStack.Push(go);
            go.SetActive(false);
        }
    }
    //回收
    public void RecycleLine()
    {
        for (int i = 0; i < m_lineLst.Count; i++)
        {
            ReturnObjectToPool(m_lineLst[i]);
        }
        m_lineLst.Clear();
    }
    private void OnDestroy()
    {
        for (int i = 0; i < m_objList.Count; i++)
        {
            GameObject.Destroy(m_objList[i]);
        }
        m_objList.Clear();
        m_objList = null;
        m_objStack = null;
    }
}
